<?php echo $__env->make('admin.donation.layouts.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<body>
    <?php echo $__env->make('admin.donation.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-container">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <div class="modal-sidebar-area" id="sidebar-panel">
    	<div class="sidebar-panel">
            <div class="sidebar-header d-flex align-items-center">
                <div class="subtitle-primary"><?php echo $__env->yieldContent('model-title'); ?></div>
                <div class="close-icon" onclick="closeNav()"></div>
            </div>
            <?php echo $__env->yieldContent('model-content'); ?>
        </div>
        <div class="background-overlay" onclick="closeNav()"></div>
    </div>
    <div>
    <?php echo $__env->make('admin.donation.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('admin.donation.layouts.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container-fluid" >

        <div class="filter-container">
            <div class="row">
                <div class="col-lg-9">
                    <div class="mb-3 add-donations">
                        <label for="party_type" class="form-label">Select Party</label>
                        <select id="party_type" name="party_type" class="form-control">
                            <option value="">All</option> 
                            <option value="RVJP">RVJP</option>
                            <option value="ABRS">ABRS</option>
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-lg-3 text-right">
                    <a href="<?php echo e(route('admin.donation.create')); ?>" class="btn btn-success" style="margin-top: 20px;">Add Donation</a>
                </div>
            </div>
        </div>
        <hr>
        <table id="donation-table" class="display">
            <thead>
                <tr>
                    <th>Receipt No</th>
                    <th>Name</th>
                    <th>PAN No</th>
                    <th>Address</th>
                    <th>Amount</th>
                    <th>Actions</th>
                    <th>Download PDF</th>
                </tr>
            </thead>
        </table>

        <div class="modal fade" id="smallModal" tabindex="-1" role="dialog" aria-labelledby="smallModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body" id="smallBody">
                        <div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function () {
            var table = $('#donation-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('admin.donation.data')); ?>",
                    data: function (d) {
                        d.party_type = $('#party_type').val();
                    }
                },
                columns: [
                    { data: 'receipt_no', name: 'receipt_no' },
                    { data: 'name', name: 'name' },
                    { data: 'pan_no', name: 'pan_no' },
                    { data: 'address', name: 'address' },
                    { data: 'amount', name: 'amount' },
                    { 
                        data: 'id', 
                        name: 'action', 
                        orderable: false, 
                        searchable: false,
                        render: function(data, type, row, meta) {
                            return `<a href="/admin/donation/${data}/edit" class="btn btn-secondary"><i class="fas fa-edit"></i></a> <a href="#" class="btn delete-btn btn-danger" data-url="/admin/donation/${data}/delete" data-toggle="modal" data-target="#smallModal">
                        <i class="fas fa-trash"></i> </a>`;
                        }
                    },
                    { 
                        data: 'id', 
                        name: 'download_pdf', 
                        orderable: false, 
                        searchable: false,
                        render: function(data, type, row, meta) {
                            return `<a href="/admin/donation/${data}/download-pdf" class="btn btn-primary" target="_blank"><i class="fa fa-file-pdf"></i></a>`;
                        }
                    }
                ],
                dom: 'Bfrtip',
                buttons: [
                    'csv', 'excel', 'pdf'
                ]
            });

            // Filter the table when the dropdown changes
            $('#party_type').change(function () {
                table.ajax.reload()  // Reload the DataTable with the new filter
            });

        });

        $(document).on('click', '.delete-btn', function(e) {
            e.preventDefault();
            let url = $(this).data('url');

            // Load the form into the modal body
            $.ajax({
                url: url,
                method: 'GET',
                success: function(response) {
                    $('#smallBody').html(response);
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                }
            });
        });


    </script>
</body>
<?php /**PATH /Applications/MAMP/htdocs/rtosmart-08-04-2021/rvjp/resources/views/admin/donation/index.blade.php ENDPATH**/ ?>