<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'admin', 'namespace' => 'Admin', 'as' => 'admin.'], function () {

	Auth::routes();

	Route::get('dashboard', 'DashboardController@index')->name('dashboard');

	Route::group(['middleware' => 'admin', 'revalidate'], function(){
		
		Route::get('logout', 'Auth\LoginController@logout')->name('logout');
		
		Route::get('account/password', 'ProfileController@password')->name('account.password');
		Route::post('account/password', 'ProfileController@updatePassword')->name('account.password.update');
		
		Route::get('account/notification', 'ProfileController@notification')->name('account.notification');
		
		Route::get('account/report', 'ProfileController@report')->name('account.report');
		
		Route::get('account/danger', 'ProfileController@danger')->name('account.danger');

		Route::get('donation/datatables', 'UserController@getDonationsData')->name('donation.data');

		Route::resource('donation', UserController::class);

		Route::get('/donation/{id}/delete', 'UserController@delete')->name('donation.delete');

		Route::get('/donation/{id}/download-pdf', 'UserController@downloadPDF')->name('donation.download');
		
		Route::get('/donation/data/export-csv', 'UserController@exportCSV')->name('donation.export');

		//--- End Account Routes

	});

});
