<?php

namespace App\Jobs;

use App\Models\Service;
use App\Models\SubService;

class ServiceJob
{
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $data;
    public function __construct($data) {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    /*
        | Description : It will store resource in DB if not exists else update it.
    */
    public function handle() {
        
        if (!isset($this->data['id'])) {
            $this->data['id'] = null;
        }
        
        if($this->data['type'] == 'Service') {
            $data = Service::firstOrNew(['id' => $this->data['id']]);
        } else {
            $data = SubService::firstOrNew(['id' => $this->data['id']]);
            $this->data['data'] = serialize($this->data['descriptionRepeat']['descriptionRepeat']);
            $this->data['name'] = $this->data['model_name'];
            $this->data['order_no'] = $this->data['model_order_no'];
        }
        
        $data->fill($this->data);

        if(isset($this->data['image'])) {
            $filenamewithextension = $this->data['image']->getClientOriginalName();

            //get filename without extension
            $filename = pathinfo($filenamewithextension, PATHINFO_FILENAME);
            
            //get file extension
            $extension = $this->data['image']->getClientOriginalExtension();
            
            //filename to store
            $filenametostore = $filename . '_' . time() . '.' . $extension;

            if($this->data['type'] == 'Service') {
                $this->data['image']->storeAs('public/services/', $filenametostore);
                $data->image = 'services/'. $filenametostore;
            } else {
                $this->data['image']->storeAs('public/sub_services/', $filenametostore);
                $data->image = 'sub_services/'. $filenametostore;
            }
        }
        
        $data->save();
    }
}
