<?php

namespace App\Jobs;

use App\Models\Manufacture;
use App\Models\ManufactureModel;

class ManufactureModelJob
{
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $data;
    public function __construct($data) {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    /*
                | Description : It will store resource in DB if not exists else update it.
    */
    public function handle() {
        
        if (!isset($this->data['id'])) {
            $this->data['id'] = null;
        }
        if($this->data['type'] == 'Manufacturer') {
            $data = Manufacture::firstOrNew(['id' => $this->data['id']]);
        } else {
            $data = ManufactureModel::firstOrNew(['id' => $this->data['id']]);
        }
        // dd($this->data);
        $data->fill($this->data);

        if($this->data['image']) {
            $filenamewithextension = $this->data['image']->getClientOriginalName();

            //get filename without extension
            $filename = pathinfo($filenamewithextension, PATHINFO_FILENAME);
            
            //get file extension
            $extension = $this->data['image']->getClientOriginalExtension();
            
            //filename to store
            $filenametostore = $filename . '_' . time() . '.' . $extension;

            if($this->data['type'] == 'Manufacturer') {
                $this->data['image']->storeAs('public/manufactures/', $filenametostore);
                $data->image = 'manufactures/'. $filenametostore;
            } else {
                $this->data['image']->storeAs('public/models/', $filenametostore);
                $data->image = 'models/'. $filenametostore;
            }
        }
        
        $data->save();
    }
}
